import pandas as pd  
import numpy as np  
import seaborn as sns  
import matplotlib.pyplot as plt  
from sklearn.preprocessing import LabelEncoder  
from sklearn.linear_model import LogisticRegression  
from sklearn.model_selection import train_test_split  
from sklearn.metrics import classification_report, confusion_matrix  
import pickle
  
# Load the dataset  
credit_customers = pd.read_csv("credit_customers.csv")  
  
# Encode categorical variables  
le = LabelEncoder()  
categorical_columns = credit_customers.select_dtypes(include=['object']).columns  
for column in categorical_columns:  
    credit_customers[column] = le.fit_transform(credit_customers[column])  
  
# Create a correlation matrix  
corr_matrix = credit_customers.corr()  
plt.figure(figsize=(12, 10))  
sns.heatmap(corr_matrix, annot=True, cmap='coolwarm')  
plt.title("Correlation Matrix")  
plt.savefig('ref_result/Correlation_Matrix.png') 
plt.show()  
  
# Prepare data for logistic regression  
X = credit_customers.drop('class', axis=1)  
y = credit_customers['class']  
  
# Split data into training and testing sets  
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.3, random_state=42)  
  
# Fit logistic regression model  
log_reg = LogisticRegression(max_iter=1000)  
log_reg.fit(X_train, y_train)  
  
# Predict on test set  
y_pred = log_reg.predict(X_test)  
  
# Evaluate the model  
print(classification_report(y_test, y_pred)) 
pickle.dump(classification_report(y_test, y_pred), open("./ref_result/classification_report.pkl","wb"))
print(confusion_matrix(y_test, y_pred))  
pickle.dump(confusion_matrix(y_test, y_pred), open("./ref_result/confusion_matrix.pkl","wb"))
  
# Display feature importances  
feature_importances = pd.DataFrame(log_reg.coef_[0], index=X.columns, columns=['importance']).sort_values('importance', ascending=False)  
print("\nFeature Importances:")  
print(feature_importances)
pickle.dump(feature_importances, open("./ref_result/feature_importances.pkl","wb")) 


